# web_views.py
from django.shortcuts import render

def index_view(request):
    return render(request, 'index.html')

def terms_view(request):
    return render(request, 'terms.html')

def privacy_view(request):
    return render(request, 'privacy.html')

def about_view(request):
    return render(request, 'about.html')

def contact_view(request):
    return render(request, 'contact.html')

def login_view(request):
    return render(request, 'login.html', {'is_public_page': True})

def signup_view(request):
    return render(request, 'signup.html', {'is_public_page': True})
    
def forgot_password_view(request):
    return render(request, 'forgot_password.html', {'is_public_page': True})

def home_view(request):
    return render(request, 'home.html')

def search_view(request):
    return render(request, 'search.html')

def downloads_view(request):
    return render(request, 'downloads.html')

def account_view(request):
    return render(request, 'account.html')

def category_detail_view(request, category_name):
    return render(request, 'category_detail.html', {'category_name': category_name})

def explore_view(request):
    return render(request, 'explore.html')

def movie_request_view(request):
    return render(request, 'movie_request.html')

def movie_detail_view(request, movie_id):
    return render(request, 'movie_detail.html', {'movie_id': movie_id})

def series_detail_view(request, series_id):
    return render(request, 'series_detail.html', {'series_id': series_id})

def see_all_view(request):
    return render(request, 'see_all.html')