# Generated by Django 5.1.4 on 2025-01-10 22:34

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('image', models.ImageField(blank=True, null=True, upload_to='category_images/')),
            ],
        ),
        migrations.CreateModel(
            name='Season',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('season_number', models.PositiveIntegerField()),
                ('title', models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, unique=True)),
                ('description', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Banner',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, max_length=200)),
                ('image', models.ImageField(upload_to='banners/')),
                ('is_active', models.BooleanField(default=True)),
                ('object_id', models.PositiveIntegerField(blank=True, null=True)),
                ('content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='contenttypes.contenttype')),
            ],
        ),
        migrations.CreateModel(
            name='Episode',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200)),
                ('episode_number', models.PositiveIntegerField()),
                ('video_file', models.FileField(upload_to='episodes/original/')),
                ('video_360p', models.FileField(blank=True, null=True, upload_to='episodes/360p/')),
                ('video_480p', models.FileField(blank=True, null=True, upload_to='episodes/480p/')),
                ('video_720p', models.FileField(blank=True, null=True, upload_to='episodes/720p/')),
                ('video_1080p', models.FileField(blank=True, null=True, upload_to='episodes/1080p/')),
                ('release_date', models.DateField()),
                ('season', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='episodes', to='api.season')),
            ],
        ),
        migrations.CreateModel(
            name='Series',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200)),
                ('description', models.TextField()),
                ('release_date', models.DateField()),
                ('genre', models.CharField(default='Unknown', max_length=100)),
                ('image', models.ImageField(blank=True, null=True, upload_to='series_images/')),
                ('banner', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='api.banner')),
                ('category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='api.category')),
                ('tag', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='api.tag')),
            ],
        ),
        migrations.AddField(
            model_name='season',
            name='series',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='seasons', to='api.series'),
        ),
        migrations.CreateModel(
            name='Movie',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200)),
                ('description', models.TextField()),
                ('release_date', models.DateField()),
                ('rating', models.FloatField()),
                ('genre', models.CharField(max_length=100)),
                ('duration', models.PositiveIntegerField()),
                ('poster', models.ImageField(blank=True, null=True, upload_to='posters/')),
                ('video_file', models.FileField(blank=True, null=True, upload_to='videos/original/')),
                ('video_360p', models.FileField(blank=True, null=True, upload_to='videos/360p/')),
                ('video_480p', models.FileField(blank=True, null=True, upload_to='videos/480p/')),
                ('video_720p', models.FileField(blank=True, null=True, upload_to='videos/720p/')),
                ('video_1080p', models.FileField(blank=True, null=True, upload_to='videos/1080p/')),
                ('streaming_url', models.URLField(blank=True, null=True)),
                ('views', models.PositiveIntegerField(default=0)),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='movies', to='api.category')),
                ('tag', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='api.tag')),
            ],
        ),
    ]
