# web_urls.py
from django.urls import path
from . import web_views

urlpatterns = [
    path('', web_views.index_view, name='index'),
    path('login/', web_views.login_view, name='login'),
    path('signup/', web_views.signup_view, name='signup'),
    path('home/', web_views.home_view, name='home'),
    path('search/', web_views.search_view, name='search'),
    path('downloads/', web_views.downloads_view, name='downloads'),
    path('account/', web_views.account_view, name='account'),
    path('category/<str:category_name>/', web_views.category_detail_view, name='category_detail'),
    path('explore/', web_views.explore_view, name='explore'),
    path('request-movie/', web_views.movie_request_view, name='movie_request'),
    path('movie/<int:movie_id>/', web_views.movie_detail_view, name='movie_detail'),
    path('series/<int:series_id>/', web_views.series_detail_view, name='series_detail'),
    path('see-all/', web_views.see_all_view, name='see_all'),
    path('terms/', web_views.terms_view, name='terms'),
    path('privacy/', web_views.privacy_view, name='privacy'),
    path('about/', web_views.about_view, name='about'),
    path('contact/', web_views.contact_view, name='contact'),
]