from django.urls import path
from .views import (
    CarouselBannerListView, LoginView, MovieListCreateView, MovieDetailView, MovieRequestView, 
    MoviesByCategoryAndTagView, MoviesByCategoryView, MoviesByTagAPIView, RegisterView, 
    SearchView, SeriesByCategoryAndTagView, SeriesByCategoryView, CategoryListView, 
    BannerListView, SeriesListView, TagsAPIView, SeriesDetailView
)

urlpatterns = [
    path('categories/', CategoryListView.as_view(), name='category-list'),
    path('categories/<str:category_name>/movies/', MoviesByCategoryView.as_view(), name='movies-by-category'),
    path('categories/<str:category_name>/series/', SeriesByCategoryView.as_view(), name='series-by-category'),
    path('movies/', MovieListCreateView.as_view(), name='movie-list-create'),
    path('categories/<str:category_name>/movies/<str:tag_name>/', MoviesByCategoryAndTagView.as_view(), name='movies-by-category-and-tag'),
    path('categories/<str:category_name>/series/<str:tag_name>/', SeriesByCategoryAndTagView.as_view(), name='series-by-category-and-tag'),
    path('tags/<str:tag_name>/', MoviesByTagAPIView.as_view(), name='movies_by_tag'),
    path('tags/', TagsAPIView.as_view(), name='tags-list'),
    path('movies/<int:pk>/', MovieDetailView.as_view(), name='movie-detail'),
    path('series/', SeriesListView.as_view(), name='series-list'),
    path('series/<int:pk>/', SeriesDetailView.as_view(), name='series-detail'),
    path('banners/', BannerListView.as_view(), name='banner-list'),
    path('carousel-banners/', CarouselBannerListView.as_view(), name='carousel-banner-list'),
    path('search/', SearchView.as_view(), name='search'),
    path('register/', RegisterView.as_view(), name='register'),
    path('login/', LoginView.as_view(), name='login'),
    path('movie-request/', MovieRequestView.as_view(), name='movie-request'),
]